//
//  IFActivityView.m
//  Downloader
//
//  Created by LiDong on 13-3-17.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import "IFActivityView.h"
#import "FSOperationManager.h"
#import <QuartzCore/QuartzCore.h>

@implementation IFActivityView

@synthesize delegate = _delegate;

- (id)initWithTitle:(NSString *)title {
    self = [super initWithFrame:CGRectZero];
    if (self) {
        [self setBackgroundColor:UIColorClear];
        [self setClipsToBounds:YES];
        [self setAutoresizesSubviews:NO];
        [self setAutoresizingMask:UIFlxSize];
        
        _contentView = [[UIView alloc] initWithFrame:RECT(0, 0, 240, 120)];
        [_contentView setBackgroundColor:RGBA(0, 0, 0, 0.8)];
        
        CALayer *contentLayer = [_contentView layer];
        const CGSize shadowOffset = { 1, 1 };
        
        [contentLayer setBorderColor:[RGBA(0.75f, 0.75f, 0.75f, 0.9f) CGColor]];
        [contentLayer setBorderWidth:1.f];
        [contentLayer setCornerRadius:10];
        [contentLayer setShadowColor:CGColorBlack];
        [contentLayer setShadowOpacity:0.65f];
        [contentLayer setShadowOffset:shadowOffset];
        
        _titleLabel = [[UILabel alloc] initWithFrame:RECT(10, 15, 220, 40)];
        [_titleLabel setBackgroundColor:UIColorClear];
        [_titleLabel setTextColor:UIColorWhite];
        [_titleLabel setTextAlignment:NSTextAlignmentCenter];
        [_titleLabel setFont:UIFontBold16];
        [_titleLabel setText:title];
        [_contentView addSubview:_titleLabel];
        
        _activieyIndicatorView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
        [_activieyIndicatorView setHidesWhenStopped:YES];
        [_activieyIndicatorView setCenter:CGPointMake(120, 80)];
        
        [_contentView addSubview:_activieyIndicatorView];
        
        _closeButton = [[UIButton alloc] initWithFrame:RECT(0, 0, 32, 32)];
        [_closeButton setImageEdgeInsets:UIEdgeInsetsMake(5, 5, 5, 5)];
        [_closeButton setShowsTouchWhenHighlighted:YES];
        [_closeButton setImage:[UIImage imageNamed:@"bar/close.png"] forState:UIControlStateNormal];
        [_closeButton addTarget:self action:@selector(close) forControlEvents:UIControlEventTouchUpInside];
        [_contentView addSubview:_closeButton];
        
        [self addSubview:_contentView];
    }
    return self;
}

- (void)dealloc {
}

- (void)willMoveToSuperview:(UIView *)newSuperview {
    if (newSuperview) {
        [self setFrame:[newSuperview bounds]];
        [_activieyIndicatorView startAnimating];
    } else {
        [_activieyIndicatorView stopAnimating];
    }
}

- (void)layoutSubviews {
    const CGRect bounds = [self bounds];
    const CGPoint center = { bounds.size.width / 2.f, bounds.size.height / 2.f };
    
    [_contentView setCenter:center];
}

- (void)setHidesCloseButton:(BOOL)hidden {
    [_closeButton setHidden:hidden];
}

- (void)show {
    UIWindow *keyWindow = [theApplication keyWindow];
    NSArray *subviews = [keyWindow subviews];
    
    if ([subviews count] > 0) {
        [self setAlpha:0];
        
        [[subviews lastObject] addSubview:self];
        
        [UIView beginAnimations:nil context:NULL];
        [UIView setAnimationDuration:0.3];
        [self setAlpha:1.f];
        [UIView commitAnimations];
    }
}

- (void)done {
    [_activieyIndicatorView stopAnimating];
    [_titleLabel setText:LS(@"FINISHED_PROMPT")];
    
    const CGRect contentBounds = [_contentView bounds];
    const CGPoint contentCenter = { contentBounds.size.width / 2.f, contentBounds.size.height / 2.f };
    
    [_titleLabel setCenter:contentCenter];
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDelegate:self];
    [UIView setAnimationDidStopSelector:@selector(viewDidDismiss)];
    [UIView setAnimationDelay:0.5];
    [UIView setAnimationDuration:0.3];
    [self setAlpha:0.f];
    [UIView commitAnimations];
}

- (void)abort {
    [_activieyIndicatorView stopAnimating];
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDelegate:self];
    [UIView setAnimationDidStopSelector:@selector(viewDidDismiss)];
    [UIView setAnimationDuration:0.3];
    [self setAlpha:0.f];
    [UIView commitAnimations];
}

- (void)close {
    [[FSOperationManager sharedManager] cancel];
    [_titleLabel setText:LS(@"CANCELLING")];
}

- (void)viewDidDismiss {
    if ([_delegate respondsToSelector:@selector(activityViewDidDismiss:)]) {
        [_delegate activityViewDidDismiss:self];
    }
    [self removeFromSuperview];
}

@end
